/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.status;

import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.ui.InvalidIdException;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigException;
import com.ibm.hwmca.ui.bonsai.config.UIInfoConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.servlet.NavigationAction;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.hwmca.ui.bonsai.status.AbstractStatusMonitor;
import com.ibm.hwmca.ui.bonsai.status.StatusMonitorBean;
import com.ibm.hwmca.ui.bonsai.util.GraphicsConstants;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ManagedObjectGroupStatusMonitor
extends AbstractStatusMonitor {
    private static final String TOTAL_TEXT_KEY = "status.mogroup.total";
    private static final String EXCEPTIONS_TEXT_KEY = "status.mogroup.exceptions";
    private static final String ATTENTIONS_TEXT_KEY = "status.mogroup.attentions";
    private static final String GROUP_PARAM_KEY = "group";
    private static final String ATTENTIONS_OFF_PARAM_KEY = "attentions";
    private static final String STATUS_PATH_PARAM_KEY = "status_path";
    private String className;
    private String shortId;
    private String[] poorStatusPath;
    private int total;
    private int exceptions;
    private int attentions;
    private boolean attentionsOn = true;

    public void init(UserObject userObj, String key, Map parameters, UIInfoConfigBean uiConfigBean) {
        super.init(userObj, key, parameters, uiConfigBean);
        this.className = (String)parameters.get(GROUP_PARAM_KEY);
        this.poorStatusPath = this.convertPathToArray((String)parameters.get(STATUS_PATH_PARAM_KEY));
        String attentionsOnParam = (String)parameters.get(ATTENTIONS_OFF_PARAM_KEY);
        if (attentionsOnParam != null) {
            this.attentionsOn = !attentionsOnParam.equalsIgnoreCase("off");
        }
        this.shortId = ManagedObjectGroupStatusMonitor.getMOGroupShortId(this.className, userObj);
        if (this.shortId != null) {
            int[] data = this.getGroupData();
            this.total = data[0];
            this.exceptions = data[1];
            this.attentions = data[2];
        }
    }

    public StatusMonitorBean getStatusMonitorBean() {
        if (this.shortId == null) {
            return null;
        }
        Locale locale = this.getUserObject().getLocale();
        String url = null;
        String statusImage = GraphicsConstants.getNormalImageIcon();
        String[] details = null;
        if (this.total == 0) {
            details = new String[]{new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", TOTAL_TEXT_KEY, new String[]{"0"}).toString(locale)};
        } else {
            String[] stringArray;
            if (this.exceptions > 0 || this.attentions > 0) {
                url = this.getUrl(this.poorStatusPath);
                statusImage = this.exceptions > 0 ? GraphicsConstants.getErrorImageIcon() : GraphicsConstants.getWarningImageIcon();
            }
            String totalText = new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", TOTAL_TEXT_KEY, new String[]{String.valueOf(this.total)}).toString(locale);
            String exceptionsText = new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", EXCEPTIONS_TEXT_KEY, new String[]{String.valueOf(this.exceptions)}).toString(locale);
            String attentionsText = new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", ATTENTIONS_TEXT_KEY, new String[]{String.valueOf(this.attentions)}).toString(locale);
            if (this.attentionsOn) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = totalText;
                stringArray2[1] = exceptionsText;
                stringArray = stringArray2;
                stringArray2[2] = attentionsText;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = totalText;
                stringArray = stringArray3;
                stringArray3[1] = exceptionsText;
            }
            details = stringArray;
        }
        UIInfo uiInfo = this.getUIInfo();
        return new StatusMonitorBean(this.getKey(), uiInfo.getName(locale), uiInfo.getCaption(locale), uiInfo.getImageName(), url, "navigation_frame", statusImage, details, this.exceptions == 0 && this.attentions == 0);
    }

    public boolean updateData() {
        UserObject userObj = this.getUserObject();
        UIObjectsReader reader = userObj.getUIObjectsReader();
        if (this.shortId == null) {
            this.shortId = ManagedObjectGroupStatusMonitor.getMOGroupShortId(this.className, userObj);
            if (this.shortId == null) {
                return false;
            }
            int[] data = this.getGroupData();
            this.total = data[0];
            this.exceptions = data[1];
            this.attentions = data[2];
            return true;
        }
        try {
            reader.getBuffer(this.shortId);
        }
        catch (InvalidIdException iiEx) {
            this.shortId = null;
            int[] hold = new int[]{this.total, this.exceptions, this.attentions};
            boolean foundNewShortId = this.updateData();
            if (!foundNewShortId) {
                return true;
            }
            this.total = hold[0];
            this.exceptions = hold[1];
            this.attentions = hold[2];
        }
        int[] data = this.getGroupData();
        if (this.total != data[0] || this.exceptions != data[1] || this.attentions != data[2]) {
            this.total = data[0];
            this.exceptions = data[1];
            this.attentions = data[2];
            return true;
        }
        return false;
    }

    public void validateParameters(Map parameters) throws BonsaiConfigException {
        String param1 = (String)parameters.get(GROUP_PARAM_KEY);
        String param2 = (String)parameters.get(STATUS_PATH_PARAM_KEY);
        if (param1 == null || param2 == null) {
            throw new BonsaiConfigException("At least one parameter is missing from the XML configuration!");
        }
    }

    private int[] getGroupData() {
        UIObjectsReader reader = this.getUserObject().getUIObjectsReader();
        int total = reader.getLeavesForGroup(this.shortId).size();
        int exceptions = reader.getUnacceptableManagedObjectShortIdsForGroup(this.shortId).size();
        int attentions = reader.getAttentionManagedObjectShortIdsForGroup(this.shortId).size();
        return new int[]{total, exceptions, attentions};
    }

    private static String getMOGroupShortId(String className, UserObject userObj) {
        Set objIds = ManagedObjectManager.getManagedObjectManager().getInventoryObjectIds(new ClassId(className));
        if (objIds.isEmpty()) {
            return null;
        }
        ObjectId objId = (ObjectId)objIds.iterator().next();
        String shortId = UIObjectsWriter.getUIObjectsWriter().getShortObjectIdManager().getShortId(objId);
        try {
            userObj.getUIObjectsReader().getBuffer(shortId);
        }
        catch (InvalidIdException iiEx) {
            return null;
        }
        return shortId;
    }

    private String getUrl(String[] path) {
        List ids = BonsaiTreeManager.getBonsaiTreeManager().getTreeNodesByTreePath(path);
        if (ids.isEmpty()) {
            return null;
        }
        return NavigationAction.getSelectionUrl(((BonsaiTreeNode)ids.get(0)).getId());
    }

    private String[] convertPathToArray(String pathParameter) {
        StringTokenizer tokens = new StringTokenizer(pathParameter, ":");
        String[] path = new String[tokens.countTokens()];
        for (int i = 0; i < path.length; ++i) {
            path[i] = tokens.nextToken();
        }
        return path;
    }
}

